

;workspace file is created by deleting existing workspace file
;and double-clicking the executable


(defun maxmainwindow ()
  (showmainwindow)
  (apply #'mainwindow 0 0 (+ '(0 0) (list 500 (second (effective-screen-size)))))
  (listener 4 0 500 (second (effective-screen-size))))

(defun smallmainwindow ()
  (showmainwindow)
  (mainwindow 0 0 512 100)
  (listener 4 0 550 100))


(format t "~%ViSta Session Manager 1.1 July 25th, 2002.~%Copyright (c) 2001=2 by Forrest W. Young")

(setf *lispboss-make-time* t)
;(setf xlisp::*load-verbose* t)
;(setf xlisp::*file-verbose* t)
(setf XLISP::IF-DOES-NOT-EXIST t)
(setf xlisp::*lispboss-make-time* t)
(setf xlisp::*edit-lisp-files* nil)

(format t "~%; LSP-MODE: ~aing .lsp files.~%~%"(if xlisp::*edit-lisp-files* "Edit" "Load"))

(setf *startup-dir*  (get-working-directory))
(format t "; *startup-dir*   ~a~%" *startup-dir*)
(setf *startup-path* (format nil "~a\\" *startup-dir*))

(setf *default-path* (format nil "~a\\" (get-working-directory)))
(format t "; *default-path*  ~a~%" *default-path*)

(setf *ini-file* (format nil "~a~a" *default-path* "wxls32.ini"))
(msw-write-profile-string "XLisp" "LibDir" *default-path* *ini-file*)
(format t "; *ini-file*      ~a~%" *ini-file*)

(setf *lispboss-verbose*
      (equal "no"
             (string-downcase 
              (msw-get-profile-string "XLisp" "HideMainFrame" *ini-file*))))

(when *lispboss-verbose* (maxmainwindow))

(set-working-directory "..")
(setf *home-path* (format nil "~a\\" (get-working-directory)))
(format t "; *home-path*     ~a~%" *home-path*)

(setf *home-ini-file* (format nil "~a~a" *home-path* "wxls32.ini"))
(format t "; *home-ini-file* ~a~%" *home-ini-file*)

(msw-write-profile-string "ViSta" "LispBossStartedViSta" "No"  *home-ini-file*)
(msw-write-profile-string "ViSta" "LispBossRunning" "Yes" *home-ini-file*)

(setf *lispsrc-dir* (format nil "~alspsrc" *home-path*))
(msw-write-profile-string  "XLisp" "LoadLisp?" "Yes" *ini-file*)
(format t "~%; loading         ~a\\init.lsp~2%" *lispsrc-dir*)

(set-working-directory *lispsrc-dir*)
(load "init")
(format t "; returned to LispBoss~%")
(load "..\\init-functions.lsp")
(set-working-directory *lispsrc-dir*)
(load "newload.lsp")
(set-working-directory *default-path*)

;(set-filetypes)


(defun button-dialog (text choice-list action-list 
                                  &key (title "Choose Items") (cancel nil)
                                  (size nil) (location nil))
"Args: TEXT CHOICE-LIST ACTION-LIST &Key (CANCEL T) TITLE LOCATION
Presents a modeless button item dialog box. TEXT appears in the dialog box before the choice items, unless NIL. CHOICE-LIST is a list of choice-item strings. ACTION-LIST is a list of action functions, one action for each choice. When CANCEL is T (which it is by default) a CANCEL item is appended to end of each list"
  (let* ((text (if text (send text-item-proto :new text) nil))
         (buttons (mapcar #'(lambda (text action)
                              (send modal-button-proto :new text
                                    :action action))
                          choice-list action-list))
         (canceler (send button-item-proto :new "Cancel" 
                      :action #'(lambda () (send self :cancel))))
         (items (if cancel (combine buttons canceler) buttons))
         (items (if text (combine text items) items))
         ;(location (if location location (list (first (floor (* 3/4 (screen-size))))
         ;                                      (second (floor (* 1/4 (screen-size)))))))
         (dialog (send modal-dialog-proto :new 
                       items
                       :title title
                       :location location
                       ))
         )
    (defmeth canceler :cancel () (send dialog :close))
    ))

(setf *load-verbose* t)
(setf *file-verbose* t)

;place in edit lisp files mode - (setf *edit-lisp-files* t) 
;or in    load lisp files mode - (setf *edit-lisp-files* nil)

 (setf *edit-lisp-files* t) 
(setf xlisp::*edit-lisp-files* *edit-lisp-files*)

(format t "~%; LSP-MODE: ~aing .lsp files.~%~%"(if xlisp::*edit-lisp-files* "Edit" "Load"))

(msw-write-profile-string  "XLisp" "LoadLisp?" 
                           (if *edit-lisp-files* "No" "Yes") *ini-file*)


(format t "~%ViSta Session Manager 1.2 October 16th, 2002.~%Copyright (c) 2001-2 by Forrest W. Young")
(format t "~%~aing .lsp files."(if *edit-lisp-files* "Edit" "Load"))

;(when 
;   (ok-or-cancel-dialog (format nil "Save This WorkSpace in~%~a?"(get-working-directory)))
;   (save-workspace "xlisp.wks"))

 (save-workspace "xlisp.wks")
